﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class SppSelectionBehaviour : MonoBehaviour, ISelectionChange {
	public Text info;
	public RenderInfo[] renderInfo;
	private int selectedId = -1;
	private SppCadChild child;

	public void Initialize(GameObject root) {
		int size = root.transform.childCount;
		renderInfo = new RenderInfo[size];
		selectedId = -1;
		int i = 0;
        string materialKey = "";
        foreach (Transform child in root.transform) {
            renderInfo[i] = new RenderInfo ();
			renderInfo [i].renderers = child.gameObject.GetComponentsInChildren<MeshRenderer>();
			renderInfo[i].materials = new MaterialInfo[renderInfo [i].renderers.Length];
			for (int j = 0; j < renderInfo [i].renderers.Length; j++) {
				renderInfo [i].materials [j] = new MaterialInfo ();
				// original color
				Color orgColor = renderInfo[i].renderers[j].material.color;
                if (orgColor.a < 1)
                {
                    materialKey = "T" + ColorUtility.ToHtmlStringRGBA(orgColor);

                }
                else
                {
                    materialKey = "O" + ColorUtility.ToHtmlStringRGB(orgColor);
                }
                renderInfo[i].materials[j].originalMaterial = SppMaterial.GetMaterial(materialKey, orgColor);

                // transparent material
                // Material transparent = new Material (SppBinaryReader.GetTransparentShader());
                Color transparentColor = new Color(orgColor.r, orgColor.g, orgColor.b, 0.25f);
                materialKey = "O" + ColorUtility.ToHtmlStringRGB(orgColor);

                renderInfo[i].materials[j].transparentMaterial = SppMaterial.GetMaterial(materialKey, transparentColor);
                // selection material

                Color greenishColor = CalculateSelectionColor(orgColor);
                materialKey = "O" + ColorUtility.ToHtmlStringRGB(greenishColor);
                renderInfo[i].materials[j].selectionMaterial = SppMaterial.GetMaterial(materialKey, greenishColor);
            }	
			SppRenderInfoBehaviour script = child.gameObject.AddComponent<SppRenderInfoBehaviour> ();
			script.renderInfo = renderInfo [i];
			i++;
		}	
	}	

	private Color CalculateSelectionColor(Color c) {
		float cv = (c.r + c.g + c.b) / 3f;
		if (cv < 0.25f)
			cv = 0.25f;
		return new Color (cv / 4f, cv, cv / 4f, c.a);
	}	

	private void SetOriginal(int idx) {
		for (int i = 0; i < renderInfo [idx].renderers.Length; i++) {
			renderInfo [idx].renderers [i].material = renderInfo [idx].materials [i].originalMaterial;
		}	
	}	

	private void SetSelection(int idx) {
		for (int i = 0; i < renderInfo [idx].renderers.Length; i++) {
			renderInfo [idx].renderers [i].material = renderInfo [idx].materials [i].selectionMaterial;
		}	
		if (info != null) {
			string txt;
			if (child != null) {
				txt = child.displayName + " (" + child.dataType + ") dimension: " + child.dimension + child.dimensionUnit + " weight: " + child.weight + child.weightUnit;
				if (child.isBuyPart.ToLower() == "yes") {
					txt += (" order#: " + child.orderNumber);
				}	
			} else {
				txt = "";
			}	
			info.text = txt;
		}	
	}	

	public void OnSelectionChange(GameObject selected) {
		if (selected == null) {
			SetOriginal (selectedId);
			selectedId = -1;
			return;
		}

		if (selectedId != -1) {
			SetOriginal (selectedId);
		}	
		selectedId = SppUtility.IdFromName (selected.name);
		child = null;
		if (selectedId != -1) {
			SppCadChildBehaviour script = selected.GetComponent<SppCadChildBehaviour> ();
			if (script != null) {
				child = script.info;
			}
			SetSelection (selectedId);
		}	
	}	
}
